// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/url_loader.mojom
//

package org.chromium.mojom.mojo;

public final class UrlLoaderStatus extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public NetworkError error;
    public boolean isLoading;

    private UrlLoaderStatus(int version) {
        super(STRUCT_SIZE, version);
    }

    public UrlLoaderStatus() {
        this(0);
    }

    public static UrlLoaderStatus deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static UrlLoaderStatus decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        UrlLoaderStatus result = new UrlLoaderStatus(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
            result.error = NetworkError.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.isLoading = decoder0.readBoolean(16, 0);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(error, 8, true);
        encoder0.encode(isLoading, 16, 0);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        UrlLoaderStatus other = (UrlLoaderStatus) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.error, other.error))
            return false;
        if (this.isLoading != other.isLoading)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(error);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(isLoading);
        return result;
    }
}

